<?php

class Ping{
    /**
     * Created by PhpStorm.
     * User: mohamed
     * Date: 2/12/22
     * Time: 2:49 PM
     * @param $url
     * @return bool|string
     */

    protected function sendGetRequest($url) {

        $refererUrl = $_SERVER['HTTP_REFERER'] ?? '';
        $http_user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERAGENT, $http_user_agent);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        $result = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            curl_close($ch);
            return ($error_msg);
        }

        curl_close($ch);
        return $httpCode;

    }

    protected function _scanAllDir($dir)
    {
        $result = [];
        $homeFiles = [];
        foreach (scandir($dir) as $filename) {

            $filePath = $dir . '/' . $filename;
            if (is_dir($filePath)) {
                if ($filename[0] === '.' || $filename[0] === '.') continue;
                $result[$filename]['dir'] = $filename;
                $result[$filename]['files'] = array_diff(scandir($filePath), array('..', '.'));
            } else {
                $homeFiles[] = $filename;
            }
        }
        $result['/']['dir'] = 'home';
        $result['/']['files'] = $homeFiles;
        return $result;
    }

    protected function getAllDirs($dir) {
        return $this->_scanAllDir($dir);
    }


    public function pingToGoogle(){
        $result = [];
        $url = "https://www.google.com/ping?sitemap=";

        $baseUrl = "https://$_SERVER[HTTP_HOST]/";


        $trendFileName = 't-shirt-trend.xml';
        if (file_exists($trendFileName)) {

            $returnCode = $this->sendGetRequest($url.$baseUrl.$trendFileName);
            $result[]= [
                "$trendFileName" => "$trendFileName => $returnCode"
            ];
        }

        $mainSitemap = 'sitemap.xml';
        if (file_exists($mainSitemap)) {

            $returnCode = $this->sendGetRequest($url.$baseUrl.$mainSitemap);
            $result[]= [
                "$mainSitemap" => "$mainSitemap => $returnCode"
            ];
        }


        return $result;

        // send sitemaps inside sitemap dir
        $scanned_coreFilesDir = $this->getAllDirs('sitemap');

        $siteMapFilesDir = $scanned_coreFilesDir['/']['files'];

        foreach ($siteMapFilesDir as $file) {

            $file_ext = substr($file, strrpos($file, '.')+1);

            if ($file_ext !== 'xml'){
                continue;
            }
            $file = 'sitemap/'.$file;

            if (file_exists($file)) {

                $returnCode = $this->sendGetRequest($url.$baseUrl.$file);
                $result[]= [
                    "$file" => "$file => $returnCode"
                ];
            }


        }

        return $result;
    }

}

$ping = new Ping();


$result = $ping->pingToGoogle();

header("Content-Type: application/json");
echo json_encode($result);
